/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing.lexer;

import com.aptana.parsing.lexer.ILexeme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lexeme<T>
implements ILexeme {
    private String _text;
    private int _startingOffset;
    private int _endingOffset;
    private T _type;

    public Lexeme(T type, int startingOffset, int endingOffset, String text) {
        this._type = type;
        this._startingOffset = startingOffset;
        this._endingOffset = endingOffset;
        this._text = text;
    }

    @Override
    public boolean contains(int offset) {
        return this.getStartingOffset() <= offset && offset <= this.getEndingOffset();
    }

    @Override
    public int getEndingOffset() {
        return this._endingOffset;
    }

    @Override
    public int getLength() {
        if (this._text != null) {
            return this._text.length();
        }
        return -1;
    }

    @Override
    public int getStartingOffset() {
        return this._startingOffset;
    }

    @Override
    public String getText() {
        return this._text;
    }

    public T getType() {
        return this._type;
    }

    public boolean isContiguousWith(Lexeme<T> secondLexeme) {
        boolean result = true;
        if (secondLexeme != null) {
            result = this.getEndingOffset() + 1 == secondLexeme.getStartingOffset();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this._endingOffset < this._startingOffset;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String type = this._type.toString();
        buffer.append(type);
        buffer.append(" [");
        buffer.append(this.getStartingOffset()).append('-').append(this.getEndingOffset());
        buffer.append(',').append(this.getText());
        buffer.append(']');
        return buffer.toString();
    }
}

